ORCA/M Asm65816 2.1.0

0001 EC02                       TITLE ', RELOCATION.a - Do_LCONST'
0002 EC02
0003 EC02              *
0004 EC02              ****************************************************************
0005 EC02              *
0006 EC02              *        Process LCONST record
0007 EC02              *
0008 EC02              *        This is NOT a subroutine.  It is entered with a JMP
0009 EC02              *        and exits to either: RELOC_LOOP, RELOC_ERROR or
0010 EC02              *        RELOC_RETURN which are in 'Do_Segment'.
0011 EC02              *
0012 EC02              ****************************************************************
0013 EC02              *
0014 EC02              Do_LCONST PROC 
0015 EC02                       with DirectPage, Globals
0016 EC02              ;
0017 EC02              ;        read rest of record header
0018 EC02              ;
0019 EC02 A2 04 00              ldx   #4
0020 EC05 20 BC F0              jsr   Read_Record
0021 EC08 B0 29                 bcs   to_reloc_error
0022 EC0A              ;
0023 EC0A              ;        read record into memory
0024 EC0A              ;
0025 EC0A D4 26        cont1    pei   CAddress+2
0026 EC0C D4 24                 pei   CAddress
0027 EC0E AD 06 A7              lda   |Record+2
0028 EC11 48                    pha   
0029 EC12 AD 04 A7              lda   |Record
0030 EC15 48                    pha   
0031 EC16 20 D2 EF              jsr   Read_File
0032 EC19 B0 18                 bcs   to_reloc_error
0033 EC1B              ;
0034 EC1B              ;        if Pathname Segment, add pathnames to Pathname Table
0035 EC1B              ;
0036 EC1B AD CC A6              lda   Header.Kind
0037 EC1E 29 1F 00              and   #%11111
0038 EC21 C9 04 00              cmp   #Path_Segment
0039 EC24 D0 10                 bne   cont2
0040 EC26 D4 0A                 pei   Handle+2
0041 EC28 D4 08                 pei   Handle
0042 EC2A D4 26                 pei   CAddress+2
0043 EC2C D4 24                 pei   CAddress
0044 EC2E 20 61 E9              jsr   Do_Path_Segment
0045 EC31 90 15                 bcc   cont3
0046 EC33              to_reloc_error  
0047 EC33 4C 28 E9              jmp   Reloc_Error
0048 EC36              ;
0049 EC36              ;        if Jump Table Segment, chain to existing Tables
0050 EC36              ;
0051 EC36 C9 02 00     cont2    cmp   #Jump_Segment
0052 EC39 D0 0D                 bne   cont3
0053 EC3B D4 0A                 pei   Handle+2
0054 EC3D D4 08                 pei   Handle
0055 EC3F D4 26                 pei   CAddress+2
0056 EC41 D4 24                 pei   CAddress
0057 EC43 20 EB E9              jsr   Do_Jump_Segment
0058 EC46 B0 EB                 bcs   to_reloc_error
0059 EC48              ;
0060 EC48              ;        bump address of memory by the # of bytes read
0061 EC48              ;
0062 EC48                       entry update_cAddress
0063 EC48              update_cAddress  
0064 EC48 AD 04 A7     cont3    lda   |Record
0065 EC4B 18                    clc   
0066 EC4C 65 24                 adc   CAddress
0067 EC4E 85 24                 sta   CAddress
0068 EC50 AD 06 A7              lda   |Record+2
0069 EC53 65 26                 adc   CAddress+2
0070 EC55 85 26                 sta   CAddress+2
0071 EC57
0072 EC57 4C 07 E9              jmp   Reloc_Loop
0073 EC5A
0074 EC5A                       ENDP 
0075 EC5A
0076 EC5A                       TITLE ', RELOCATION.a - Do_DS'
0077 EC5A              *
0078 EC5A              ****************************************************************
0079 EC5A              *
0080 EC5A              *        Process DS record
0081 EC5A              *
0082 EC5A              *        This is NOT a subroutine.  It is entered with a JMP
0083 EC5A              *        and exits to either: RELOC_LOOP, RELOC_ERROR or
0084 EC5A              *        RELOC_RETURN which are in 'Do_Segment'.
0085 EC5A              *
0086 EC5A              ****************************************************************
0087 EC5A              *
0088 EC5A              Do_DS    PROC 
0089 EC5A                       with DirectPage, Globals
0090 EC5A
0091 EC5A              ;
0092 EC5A              ;        read rest of record
0093 EC5A              ;
0094 EC5A A2 04 00              ldx   #4
0095 EC5D 20 BC F0              jsr   Read_Record
0096 EC60 90 03                 bcc   @1
0097 EC62 4C 28 E9              jmp   Reloc_Error
0098 EC65              @1        
0099 EC65              ;
0100 EC65              ;        memory does not have to be zeroed by this subroutine
0101 EC65              ;        because the whole memory segment was zeroed by
0102 EC65              ;        'Allocate_Segment'
0103 EC65              ;
0104 EC65              ;        bump address of memory by the # of bytes zeroed
0105 EC65              ;
0106 EC65 80 E1                 bra   update_cAddress
0107 EC67
0108 EC67                       ENDP 
0109 EC67
0110 EC67                       TITLE ', RELOCATION.a - Do_RELOC'
0111 EC67              *
0112 EC67              ****************************************************************
0113 EC67              *
0114 EC67              *        Process RELOC record
0115 EC67              *
0116 EC67              *        This is NOT a subroutine.  It is entered with a JMP
0117 EC67              *        and exits to either: RELOC_LOOP, RELOC_ERROR or
0118 EC67              *        RELOC_RETURN which are in 'Do_Segment'.
0119 EC67              *
0120 EC67              *   Inputs:     CAddress    - Segment Address
0121 EC67              *   Outputs:    TempZero    - Address to be patched
0122 EC67              *               TempZero+4  - Value of patch
0123 EC67              *
0124 EC67              ****************************************************************
0125 EC67              *
0126 EC67              Do_RELOC PROC 
0127 EC67                       with DirectPage, Globals
0128 EC67
0129 EC67              Bytes    equ   0                        ;# of bytes in patch
0130 EC67              Shift    equ   1                        ;shift count
0131 EC67              Offset   equ   2                        ;offset of patch in segment
0132 EC67              Value    equ   6                        ;offset of reference in segment
0133 EC67
0134 EC67 A2 0A 00              ldx   #10
0135 EC6A 20 59 EE              jsr   Common_Pass1_Check
0136 EC6D              ;
0137 EC6D              ;        calculate address of patch = Load Address + Offset
0138 EC6D              ;
0139 EC6D A5 24                 lda   CAddress
0140 EC6F 18                    clc   
0141 EC70 6D 06 A7              adc   |Record+Offset
0142 EC73 85 00                 sta   TempZero
0143 EC75 A5 26                 lda   CAddress+2
0144 EC77 6D 08 A7              adc   |Record+Offset+2
0145 EC7A 85 02                 sta   TempZero+2
0146 EC7C              ;
0147 EC7C              ;        calculate patch = Load Address + Value
0148 EC7C              ;
0149 EC7C A5 24                 lda   CAddress
0150 EC7E 18                    clc   
0151 EC7F 6D 0A A7              adc   |Record+Value
0152 EC82 85 04                 sta   TempZero+4
0153 EC84 A5 26                 lda   CAddress+2
0154 EC86 6D 0C A7              adc   |Record+Value+2
0155 EC89 85 06                 sta   TempZero+6
0156 EC8B 4C CB EE              jmp   Common_Reloc
0157 EC8E
0158 EC8E                       ENDP 
0159 EC8E
0160 EC8E                       TITLE ', RELOCATION.a - Do_cRELOC'
0161 EC8E              *
0162 EC8E              ****************************************************************
0163 EC8E              *
0164 EC8E              *        Process compressed RELOC record
0165 EC8E              *
0166 EC8E              *        This is NOT a subroutine.  It is entered with a JMP
0167 EC8E              *        and exits to either: RELOC_LOOP, RELOC_ERROR or
0168 EC8E              *        RELOC_RETURN which are in 'Do_Segment'.
0169 EC8E              *
0170 EC8E              *   Inputs:     CAddress    - Segment Address
0171 EC8E              *   Outputs:    TempZero    - Address to be patched
0172 EC8E              *               TempZero+4  - Value of patch
0173 EC8E              *
0174 EC8E              ****************************************************************
0175 EC8E              *
0176 EC8E              Do_cRELOC PROC 
0177 EC8E                       with DirectPage, Globals
0178 EC8E
0179 EC8E              Bytes    equ   0                        ;# of bytes in patch
0180 EC8E              Shift    equ   1                        ;shift count
0181 EC8E              Offset   equ   2                        ;offset of patch in segment
0182 EC8E              Value    equ   4                        ;offset of reference in segment
0183 EC8E
0184 EC8E A2 06 00              ldx   #6
0185 EC91 20 59 EE              jsr   Common_Pass1_Check
0186 EC94              ;
0187 EC94              ;        calculate address of patch = Load Address + Offset
0188 EC94              ;
0189 EC94 AD 06 A7              lda   |Record+Offset
0190 EC97 18                    clc   
0191 EC98 65 24                 adc   CAddress
0192 EC9A 85 00                 sta   TempZero
0193 EC9C A9 00 00              lda   #0
0194 EC9F 65 26                 adc   CAddress+2
0195 ECA1 85 02                 sta   TempZero+2
0196 ECA3              ;
0197 ECA3              ;        calculate patch = Load Address + Value
0198 ECA3              ;
0199 ECA3 AD 08 A7              lda   |Record+Value
0200 ECA6 18                    clc   
0201 ECA7 65 24                 adc   CAddress
0202 ECA9 85 04                 sta   TempZero+4
0203 ECAB A9 00 00              lda   #0
0204 ECAE 65 26                 adc   CAddress+2
0205 ECB0 85 06                 sta   TempZero+6
0206 ECB2 4C CB EE              jmp   Common_Reloc             ;do common relocation logic
0207 ECB5
0208 ECB5                       ENDP 
0209 ECB5
0210 ECB5                       TITLE ', RELOCATION.a - Do_INTERSEG'
0211 ECB5              *
0212 ECB5              ****************************************************************
0213 ECB5              *
0214 ECB5              *        Process INTERSEG record
0215 ECB5              *
0216 ECB5              *        This is NOT a subroutine.  It is entered with a JMP
0217 ECB5              *        and exits to either: RELOC_LOOP, RELOC_ERROR or
0218 ECB5              *        RELOC_RETURN which are in 'Do_Segment'.
0219 ECB5              *
0220 ECB5              *   Inputs:     CAddress    - Segment Address
0221 ECB5              *   Outputs:    TempZero    - Address to be patched
0222 ECB5              *               TempZero+4  - Value of patch
0223 ECB5              *
0224 ECB5              ****************************************************************
0225 ECB5              *
0226 ECB5              Do_INTERSEG PROC 
0227 ECB5                       with DirectPage, Globals
0228 ECB5
0229 ECB5              Bytes    equ   0                        ;# of bytes in patch
0230 ECB5              Shift    equ   1                        ;shift count
0231 ECB5              Offset   equ   2                        ;offset of patch in segment
0232 ECB5              FileNum  equ   6                        ;File Number
0233 ECB5              SegNum   equ   8                        ;Segment Number
0234 ECB5              SegOffset equ   10                      ;Segment Offset
0235 ECB5
0236 ECB5 A2 0E 00              ldx   #14
0237 ECB8 20 59 EE              jsr   Common_Pass1_Check
0238 ECBB              ;
0239 ECBB              ;        do common INTERSEG logic
0240 ECBB              ;
0241 ECBB 20 8D EE              jsr   Common_INTERSEG
0242 ECBE              ;
0243 ECBE              ;        calculate address of patch = Load Address + Offset
0244 ECBE              ;
0245 ECBE A5 24                 lda   CAddress
0246 ECC0 18                    clc   
0247 ECC1 6D 06 A7              adc   |Record+Offset
0248 ECC4 85 00                 sta   TempZero
0249 ECC6 A5 26                 lda   CAddress+2
0250 ECC8 6D 08 A7              adc   |Record+Offset+2
0251 ECCB 85 02                 sta   TempZero+2
0252 ECCD              ;
0253 ECCD              ;        calculate patch = Load Address of Segment + Segment Offset
0254 ECCD              ;
0255 ECCD A5 04                 lda   TempZero+4
0256 ECCF 18                    clc   
0257 ECD0 6D 0E A7              adc   |Record+SegOffset
0258 ECD3 85 04                 sta   TempZero+4
0259 ECD5 A5 06                 lda   TempZero+6
0260 ECD7 6D 10 A7              adc   |Record+SegOffset+2
0261 ECDA 85 06                 sta   TempZero+6
0262 ECDC 4C CB EE              jmp   Common_Reloc
0263 ECDF
0264 ECDF                       ENDP 
0265 ECDF
0266 ECDF                       TITLE ', RELOCATION.a - Do_cINTERSEG'
0267 ECDF              *
0268 ECDF              ****************************************************************
0269 ECDF              *
0270 ECDF              *        Process compressed INTERSEG record
0271 ECDF              *
0272 ECDF              *        This is NOT a subroutine.  It is entered with a JMP
0273 ECDF              *        and exits to either: RELOC_LOOP, RELOC_ERROR or
0274 ECDF              *        RELOC_RETURN which are in 'Do_Segment'.
0275 ECDF              *
0276 ECDF              *   Inputs:     CAddress    - Segment Address
0277 ECDF              *   Outputs:    TempZero    - Address to be patched
0278 ECDF              *               TempZero+4  - Value of patch
0279 ECDF              *
0280 ECDF              ****************************************************************
0281 ECDF              *
0282 ECDF              Do_cINTERSEG PROC 
0283 ECDF                       with DirectPage, Globals
0284 ECDF
0285 ECDF              Bytes    equ   0                        ;# of bytes in patch
0286 ECDF              Shift    equ   1                        ;shift count
0287 ECDF              Offset   equ   2                        ;offset of patch in segment
0288 ECDF              SegNum   equ   4                        ;Segment Number
0289 ECDF              SegOffset equ   5                       ;Segment Offset
0290 ECDF
0291 ECDF A2 07 00              ldx   #7
0292 ECE2 20 59 EE              jsr   Common_Pass1_Check
0293 ECE5              ;
0294 ECE5              ;        set Handle to handle of first Memory Segment Table entry for the
0295 ECE5              ;        current UserID
0296 ECE5              ;
0297 ECE5 A5 34                 lda   FirstMemSeg
0298 ECE7 85 08                 sta   Handle
0299 ECE9 A5 36                 lda   FirstMemSeg+2
0300 ECEB 85 0A                 sta   Handle+2
0301 ECED              ;
0302 ECED              ;        find entry in Memory Segment Table corresponding to
0303 ECED              ;        FileNum and SegNum in INTERSEG record
0304 ECED              ;
0305 ECED A9 00 00              lda   #0
0306 ECF0 48                    pha                            ;output Handle
0307 ECF1 48                    pha   
0308 ECF2 AD B6 A6              lda   |USERID                  ;current UserID
0309 ECF5 48                    pha   
0310 ECF6 D4 20                 pei   CFileNum                 ;File Number
0311 ECF8 AD 08 A7              lda   |Record+SegNum           ;Segment Number
0312 ECFB 29 FF 00              and   #$FF
0313 ECFE 48                    pha   
0314 ECFF 20 7A F8              jsr   Next_MemSeg
0315 ED02 68                    pla   
0316 ED03 85 08                 sta   Handle                   ;output Handle
0317 ED05 68                    pla   
0318 ED06 85 0A                 sta   Handle+2
0319 ED08 A9 01 11              lda   #NoFind
0320 ED0B 90 03                 bcc   @1
0321 ED0D 4C 28 E9              jmp   Reloc_Error
0322 ED10              @1        
0323 ED10              ;
0324 ED10              ;        get handle of Memory Segment out of Memory Segment Table
0325 ED10              ;        and get Load Address
0326 ED10              ;
0327 ED10 BD 0A 00              lda   |MS_Handle,x
0328 ED13 BC 0C 00              ldy   |MS_Handle+2,x
0329 ED16 20 D6 FA              jsr   DeRef                    ;deference handle
0330 ED19 85 04                 sta   TempZero+4               ;save
0331 ED1B 84 06                 sty   TempZero+6
0332 ED1D
0333 ED1D 4B                    phk                            ;restore DBR
0334 ED1E AB                    plb   
0335 ED1F              ;
0336 ED1F              ;        calculate address of patch = Load Address + Offset
0337 ED1F              ;
0338 ED1F AD 06 A7              lda   |Record+Offset
0339 ED22 18                    clc   
0340 ED23 65 24                 adc   CAddress
0341 ED25 85 00                 sta   TempZero
0342 ED27 A9 00 00              lda   #0
0343 ED2A 65 26                 adc   CAddress+2
0344 ED2C 85 02                 sta   TempZero+2
0345 ED2E              ;
0346 ED2E              ;        calculate patch = Load Address of Segment + Segment Offset
0347 ED2E              ;
0348 ED2E AD 09 A7              lda   |Record+SegOffset
0349 ED31 18                    clc   
0350 ED32 65 04                 adc   TempZero+4
0351 ED34 85 04                 sta   TempZero+4
0352 ED36 90 02                 bcc   @2
0353 ED38 E6 06                 inc   TempZero+6
0354 ED3A              @2        
0355 ED3A 4C CB EE              jmp   Common_Reloc
0356 ED3D
0357 ED3D                       ENDP 
0358 ED3D
0359 ED3D                       TITLE ', RELOCATION.a - Do_SUPER'
0360 ED3D              *
0361 ED3D              ****************************************************************
0362 ED3D              *
0363 ED3D              *        Process super compressed records
0364 ED3D              *
0365 ED3D              *        This is NOT a subroutine.  It is entered with a JMP
0366 ED3D              *        and exits to either: RELOC_LOOP, RELOC_ERROR or
0367 ED3D              *        RELOC_RETURN which are in 'Do_Segment'.
0368 ED3D              *
0369 ED3D              *   Inputs:     CAddress    - Segment Address
0370 ED3D              *   Outputs:    TempZero    - Address to be patched
0371 ED3D              *               TempZero+4  - Value of patch
0372 ED3D              *
0373 ED3D              ****************************************************************
0374 ED3D              *
0375 ED3D              Do_SUPER PROC 
0376 ED3D                       with DirectPage, Globals
0377 ED3D              ;
0378 ED3D              ;        offsets in Record (only the 1st 2 fields are actually read from file)
0379 ED3D              ;
0380 ED3D              Length   equ   0                        ;length of SUPER record
0381 ED3D              Type     equ   4                        ;type of SUPER record
0382 ED3D              Byte     equ   5                        ;next byte in record
0383 ED3D              FileNum  equ   6                        ;file number of patch
0384 ED3D              SegNum   equ   8                        ;segment number of patch
0385 ED3D              Offset   equ   10                       ;segment offset of patch
0386 ED3D              PatchLoc equ   12                       ;relative address to be patched
0387 ED3D              Bytes    equ   14                       ;number of bytes to patch
0388 ED3D
0389 ED3D A2 05 00              ldx   #5
0390 ED40 20 59 EE              jsr   Common_Pass1_Check
0391 ED43              ;
0392 ED43              ;        set current patch page to 0
0393 ED43              ;
0394 ED43 9C 10 A7              stz   |Record+PatchLoc
0395 ED46              ;
0396 ED46              ;        decrement record length (for Type)
0397 ED46              ;
0398 ED46 20 4D EE              jsr   dec_rec_len
0399 ED49              ;
0400 ED49              ;        get next byte in record
0401 ED49              ;
0402 ED49 F4 01 00     loop1    pea   Record+Byte>>16
0403 ED4C F4 09 A7              pea   |Record+Byte
0404 ED4F F4 00 00              pea   0
0405 ED52 F4 01 00              pea   1
0406 ED55 20 D2 EF              jsr   Read_File
0407 ED58 B0 28                 bcs   to_reloc_error
0408 ED5A              ;
0409 ED5A              ;        decrement record length
0410 ED5A              ;
0411 ED5A 20 4D EE              jsr   dec_rec_len
0412 ED5D              ;
0413 ED5D              ;        is byte a skip count or patch count ?
0414 ED5D              ;
0415 ED5D A9 00 00              lda   #0                       ;clear high byte of accumulator
0416 ED60 E2 30                 sep   #$30
0417 ED62                       longa off
0418 ED62                       longi off
0419 ED62 AD 09 A7              lda   |Record+Byte
0420 ED65 C2 30                 rep   #$30
0421 ED67                       longa on
0422 ED67                       longi on
0423 ED67 10 06                 bpl   cont1
0424 ED69              ;
0425 ED69              ;        byte is skip count, set A to count
0426 ED69              ;
0427 ED69 29 7F FF              and   #$FF7F
0428 ED6C 4C 37 EE              jmp   eloop1
0429 ED6F              ;
0430 ED6F              ;        byte is a patch count, set Counter to patch count
0431 ED6F              ;
0432 ED6F 85 14        cont1    sta   Counter
0433 ED71              ;
0434 ED71              ;        read and process (patch count+1) bytes
0435 ED71              ;
0436 ED71 F4 01 00     loop2    pea   Record+PatchLoc>>16
0437 ED74 F4 10 A7              pea   |Record+PatchLoc
0438 ED77 F4 00 00              pea   0
0439 ED7A F4 01 00              pea   1
0440 ED7D 20 D2 EF              jsr   Read_File
0441 ED80 90 03                 bcc   _1
0442 ED82              to_reloc_error  
0443 ED82 4C 28 E9              jmp   Reloc_Error
0444 ED85              _1        
0445 ED85              ;
0446 ED85              ;        decrement record length
0447 ED85              ;
0448 ED85 20 4D EE              jsr   dec_rec_len
0449 ED88              ;
0450 ED88              ;        set TempZero to actual address to be patched = relative location +
0451 ED88              ;        address of current segment
0452 ED88              ;
0453 ED88 AD 10 A7              lda   |Record+PatchLoc
0454 ED8B 18                    clc   
0455 ED8C 65 24                 adc   CAddress
0456 ED8E 85 00                 sta   TempZero
0457 ED90 A9 00 00              lda   #0
0458 ED93 65 26                 adc   CAddress+2
0459 ED95 85 02                 sta   TempZero+2
0460 ED97              ;
0461 ED97              ;        extract segment offset and segment number (even if not there) of patch
0462 ED97              ;        from memory
0463 ED97              ;
0464 ED97 A7 00                 lda   [TempZero]
0465 ED99 8D 0E A7              sta   |Record+Offset
0466 ED9C A0 02 00              ldy   #2
0467 ED9F B7 00                 lda   [TempZero],y
0468 EDA1 29 FF 00              and   #$FF
0469 EDA4 8D 0C A7              sta   |Record+SegNum
0470 EDA7              ;
0471 EDA7              ;        RELOC2 and RELOC3 records correspond to types 0 and 1
0472 EDA7              ;        INTERSEG1-36 records correspond to types 2-37
0473 EDA7              ;
0474 EDA7 AD 08 A7              lda   |Record+Type
0475 EDAA 29 FF 00              and   #$FF
0476 EDAD              ;
0477 EDAD              ;        check for illegal SUPER record
0478 EDAD              ;
0479 EDAD C9 26 00              cmp   #38
0480 EDB0 90 05                 bcc   cont1aa
0481 EDB2 A9 0A 11              lda   #Illegal
0482 EDB5 80 CB                 bra   to_reloc_error
0483 EDB7              ;
0484 EDB7              ;        is SUPER record is of type INTERSEGn ?
0485 EDB7              ;
0486 EDB7 A2 03 00     cont1aa  ldx   #3
0487 EDBA C9 02 00              cmp   #2
0488 EDBD 90 3D                 bcc   cont2
0489 EDBF              ;
0490 EDBF              ;        SUPER record is of type INTERSEGn, check for different categories
0491 EDBF              ;
0492 EDBF C9 1A 00              cmp   #26
0493 EDC2 90 06                 bcc   cont1a
0494 EDC4              ;
0495 EDC4              ;        n is 25-36
0496 EDC4              ;        ----------
0497 EDC4              ;        Number of bytes in patch = 2
0498 EDC4              ;        File Number = 1
0499 EDC4              ;        Segment Number = n-24 (type-25)
0500 EDC4              ;        Shift Count = -16
0501 EDC4              ;
0502 EDC4 38                    sec   
0503 EDC5 E9 19 00              sbc   #25
0504 EDC8 80 09                 bra   cont1b
0505 EDCA
0506 EDCA C9 0E 00     cont1a   cmp   #14
0507 EDCD 90 0E                 bcc   cont1c
0508 EDCF              ;
0509 EDCF              ;        n is 13-24
0510 EDCF              ;        ----------
0511 EDCF              ;        Number of bytes in patch = 2
0512 EDCF              ;        File Number = 1
0513 EDCF              ;        Segment Number = n-12 (type-13)
0514 EDCF              ;        Shift Count = 0
0515 EDCF              ;
0516 EDCF 38                    sec   
0517 EDD0 E9 0D 00              sbc   #13
0518 EDD3 8D 0C A7     cont1b   sta   |Record+SegNum
0519 EDD6 A9 02 00              lda   #2
0520 EDD9 AA                    tax   
0521 EDDA 8D 12 A7              sta   |Record+Bytes
0522 EDDD                                                      ; fall through to decrement Acc to 1
0523 EDDD              ;
0524 EDDD              ;        n is 1-12
0525 EDDD              ;        ----------
0526 EDDD              ;        Number of bytes in patch = 3
0527 EDDD              ;        File Number = n (type-1)
0528 EDDD              ;        Segment Number = in patch
0529 EDDD              ;        Shift Count = 0
0530 EDDD              ;
0531 EDDD 3A           cont1c   dec   a
0532 EDDE 8D 0A A7     cont1d   sta   |Record+FileNum
0533 EDE1 8E 12 A7              stx   |Record+Bytes
0534 EDE4              ;
0535 EDE4              ;        do common INTERSEG logic
0536 EDE4              ;
0537 EDE4 20 8D EE              jsr   Common_INTERSEG
0538 EDE7              ;
0539 EDE7              ;        get record type
0540 EDE7              ;
0541 EDE7 AD 08 A7              lda   |Record+Type
0542 EDEA 29 FF 00              and   #$FF
0543 EDED AA                    tax   
0544 EDEE              ;
0545 EDEE              ;        calculate patch = Segment Address + Segment Offset
0546 EDEE              ;
0547 EDEE AD 0E A7              lda   |Record+Offset
0548 EDF1 18                    clc   
0549 EDF2 65 04                 adc   TempZero+4
0550 EDF4 85 04                 sta   TempZero+4
0551 EDF6 90 18                 bcc   cont3
0552 EDF8 E6 06                 inc   TempZero+6
0553 EDFA 80 14                 bra   cont3
0554 EDFC              ;
0555 EDFC              ;        SUPER record is a RELOC2 or RELOC3, set Bytes  to 2 or 3
0556 EDFC              ;
0557 EDFC 1A           cont2    inc   a
0558 EDFD 1A                    inc   a
0559 EDFE 8D 12 A7              sta   |Record+Bytes
0560 EE01              ;
0561 EE01              ;        calculate patch = Load Segment Address + Segment Offset
0562 EE01              ;
0563 EE01 AD 0E A7              lda   |Record+Offset
0564 EE04 18                    clc   
0565 EE05 65 24                 adc   CAddress
0566 EE07 85 04                 sta   TempZero+4
0567 EE09 A9 00 00              lda   #0
0568 EE0C 65 26                 adc   CAddress+2
0569 EE0E 85 06                 sta   TempZero+6
0570 EE10              ;
0571 EE10              ;        do actual patch - TempZero   = Patch Location
0572 EE10              ;                          TempZero+4 = Patch
0573 EE10              ;
0574 EE10 A5 04        cont3    lda   TempZero+4
0575 EE12              ;
0576 EE12              ;        if INTERSEG25-36, use high word for Patch (equivalent to shifting
0577 EE12              ;        the patch by -16)
0578 EE12              ;
0579 EE12 E0 1A 00              cpx   #26
0580 EE15 90 02                 bcc   cont3a
0581 EE17 A5 06                 lda   TempZero+6
0582 EE19 87 00        cont3a   sta   [TempZero]
0583 EE1B AD 12 A7              lda   |Record+Bytes
0584 EE1E C9 02 00              cmp   #2
0585 EE21 F0 0A                 beq   eloop2
0586 EE23 E2 30                 sep   #$30
0587 EE25                       longa off
0588 EE25                       longi off
0589 EE25 A5 06                 lda   TempZero+6
0590 EE27 A0 02                 ldy   #2
0591 EE29 97 00                 sta   [TempZero],y
0592 EE2B C2 30                 rep   #$30
0593 EE2D                       longa on
0594 EE2D                       longi on
0595 EE2D              ;
0596 EE2D              ;        finished single patch
0597 EE2D              ;
0598 EE2D C6 14        eloop2   dec   Counter
0599 EE2F 30 03                 bmi   cont4
0600 EE31 4C 71 ED              jmp   loop2
0601 EE34 A9 01 00     cont4    lda   #1
0602 EE37              ;
0603 EE37              ;        finished page, increment to next page (A=page increment)
0604 EE37              ;
0605 EE37 EB           eloop1   xba   
0606 EE38 18                    clc   
0607 EE39 6D 10 A7              adc   |Record+PatchLoc
0608 EE3C 8D 10 A7              sta   |Record+PatchLoc
0609 EE3F AD 04 A7              lda   |Record+Length           ;is record length=0?
0610 EE42 0D 06 A7              ora   |Record+Length+2
0611 EE45 F0 03                 beq   done                     ;yes, done
0612 EE47 4C 49 ED              jmp   loop1
0613 EE4A
0614 EE4A 4C 07 E9     done     jmp   Reloc_Loop
0615 EE4D
0616 EE4D              dec_rec_len  
0617 EE4D AD 04 A7              lda   |Record+Length
0618 EE50 D0 03                 bne   @1
0619 EE52 CE 06 A7              dec   |Record+Length+2
0620 EE55              @1        
0621 EE55 CE 04 A7              dec   |Record+Length
0622 EE58 60                    rts   
0623 EE59
0624 EE59                       ENDP 
0625 EE59
0626 EE59                       TITLE ', RELOCATION.a - Common_Pass1_Check'
0627 EE59              *
0628 EE59              ****************************************************************
0629 EE59              *
0630 EE59              *        Common Pass1 check
0631 EE59              *
0632 EE59              *  Inputs:     X - # of bytes left in record
0633 EE59              *
0634 EE59              *  Outputs:    none
0635 EE59              *
0636 EE59              *  Zero Page used: none
0637 EE59              ****************************************************************
0638 EE59              *
0639 EE59              Common_Pass1_Check PROC  
0640 EE59                       with DirectPage, Globals
0641 EE59              ;
0642 EE59              ;        if segment is an Initialization Segment, process even if Pass 1
0643 EE59              ;
0644 EE59 AD CC A6              lda   Header.Kind
0645 EE5C 29 1F 00              and   #%11111
0646 EE5F C9 10 00              cmp   #Init_Segment
0647 EE62 D0 0C                 bne   cont1
0648 EE64 AD D0 A6              lda   Header.Org
0649 EE67 85 24                 sta   CAddress                 ;reset load address
0650 EE69 AD D2 A6              lda   Header.Org+2
0651 EE6C 85 26                 sta   CAddress+2
0652 EE6E 80 13                 bra   cont2
0653 EE70              ;
0654 EE70              ;        if pass 1, save Op Mark in Mark List and skip rest of Segment
0655 EE70              ;
0656 EE70 A5 1C        cont1    lda   Pass
0657 EE72 D0 0F                 bne   cont2
0658 EE74 20 82 F3              jsr   Save_Mark
0659 EE77 A9 01 00              lda   #1
0660 EE7A 85 1E                 sta   Pass2_Needed
0661 EE7C 68                    pla                            ;remove return address
0662 EE7D A9 00 00              lda   #0                       ;signify no error
0663 EE80 4C 28 E9              jmp   Reloc_Return
0664 EE83              ;
0665 EE83              ;        read rest of record
0666 EE83              ;
0667 EE83 20 BC F0     cont2    jsr   Read_Record
0668 EE86 B0 01                 bcs   Common_Error
0669 EE88 60                    rts   
0670 EE89
0671 EE89                       entry Common_Error
0672 EE89              Common_Error  
0673 EE89 FA                    plx                            ;remove return address
0674 EE8A 4C 28 E9              jmp   Reloc_Error
0675 EE8D
0676 EE8D                       ENDP 
0677 EE8D
0678 EE8D                       TITLE ', RELOCATION.a - Common_INTERSEG'
0679 EE8D              *
0680 EE8D              ****************************************************************
0681 EE8D              *
0682 EE8D              *        Common INTERSEG logic
0683 EE8D              *
0684 EE8D              *   Inputs:     CAddress    - Segment Address
0685 EE8D              *   Outputs:    TempZero    - Address to be patched
0686 EE8D              *               TempZero+4  - Value of patch
0687 EE8D              *
0688 EE8D              ****************************************************************
0689 EE8D              *
0690 EE8D              Common_INTERSEG PROC 
0691 EE8D                       with DirectPage, Globals
0692 EE8D
0693 EE8D              FileNum  equ   6                        ;File Number
0694 EE8D              SegNum   equ   8                        ;Segment Number
0695 EE8D              ;
0696 EE8D              ;        set Handle to handle of first Memory Segment Table entry for the
0697 EE8D              ;        current UserID
0698 EE8D              ;
0699 EE8D A5 34                 lda   FirstMemSeg
0700 EE8F 85 08                 sta   Handle
0701 EE91 A5 36                 lda   FirstMemSeg+2
0702 EE93 85 0A                 sta   Handle+2
0703 EE95              ;
0704 EE95              ;        find entry in Memory Segment Table corresponding to
0705 EE95              ;        FileNum and SegNum in Record
0706 EE95              ;
0707 EE95 A9 00 00              lda   #0                       ;output Handle
0708 EE98 48                    pha   
0709 EE99 48                    pha   
0710 EE9A AD B6 A6              lda   |USERID                  ;current UserID
0711 EE9D 48                    pha   
0712 EE9E AD 0A A7              lda   |Record+FileNum          ;File Number
0713 EEA1 C9 01 00              cmp   #1                       ;if = 1,
0714 EEA4 D0 02                 bne   cont                     ;  use current File Number instead
0715 EEA6 A5 20                 lda   CFileNum
0716 EEA8 48           cont     pha   
0717 EEA9 AD 0C A7              lda   |Record+SegNum           ;Segment Number
0718 EEAC 48                    pha   
0719 EEAD 20 7A F8              jsr   Next_MemSeg
0720 EEB0 68                    pla   
0721 EEB1 85 08                 sta   Handle                   ;output Handle
0722 EEB3 68                    pla   
0723 EEB4 85 0A                 sta   Handle+2
0724 EEB6 A9 01 11              lda   #NoFind
0725 EEB9 B0 CE                 bcs   Common_Error
0726 EEBB              ;
0727 EEBB              ;        get handle of Memory Segment out of Memory Segment Table
0728 EEBB              ;        and get Load Address
0729 EEBB              ;
0730 EEBB BD 0A 00              lda   |MS_Handle,x
0731 EEBE BC 0C 00              ldy   |MS_Handle+2,x
0732 EEC1 20 D6 FA              jsr   DeRef                    ;deference handle
0733 EEC4 85 04                 sta   TempZero+4               ;save
0734 EEC6 84 06                 sty   TempZero+6
0735 EEC8
0736 EEC8 4B                    phk                            ;restore DBR
0737 EEC9 AB                    plb   
0738 EECA 60                    rts   
0739 EECB
0740 EECB                       ENDP 
0741 EECB
0742 EECB                       TITLE ', RELOCATION.a - Common_Reloc'
0743 EECB              *
0744 EECB              ****************************************************************
0745 EECB              *
0746 EECB              *        Common relocation logic
0747 EECB              *
0748 EECB              *        This is NOT a subroutine.  It is entered with a JML
0749 EECB              *        and exits to RELOC_LOOP.
0750 EECB              *
0751 EECB              *   Inputs:     CAddress    - Segment Address
0752 EECB              *   Outputs:    TempZero    - Address to be patched
0753 EECB              *               TempZero+4  - Value of patch
0754 EECB              *
0755 EECB              ****************************************************************
0756 EECB              *
0757 EECB              Common_Reloc PROC 
0758 EECB                       with DirectPage, Globals
0759 EECB
0760 EECB              Bytes    equ   0                        ;# of bytes in patch
0761 EECB              Shift    equ   1                        ;shift count
0762 EECB              ;
0763 EECB              ;        shift patch using Shift count
0764 EECB              ;
0765 EECB A9 00 00              lda   #0                       ;make sure upper byte is 0
0766 EECE E2 30                 sep   #$30                     ;go into 8 bit mode so that negative flag
0767 EED0                       longa off
0768 EED0                       longi off
0769 EED0 AD 05 A7              lda   |Record+Shift            ;   is set on the lda
0770 EED3 C2 30                 rep   #$30
0771 EED5                       longa on
0772 EED5                       longi on
0773 EED5 F0 2A                 beq   cont3                    ;if zero skip shift logic
0774 EED7 30 0D                 bmi   cont1                    ;if negative, do right shift
0775 EED9 AA                    tax   
0776 EEDA A5 04                 lda   TempZero+4               ;do logical left shift of 4 bytes
0777 EEDC              @loop     
0778 EEDC 0A                    asl   a
0779 EEDD 26 06                 rol   TempZero+6
0780 EEDF CA                    dex   
0781 EEE0 D0 FA                 bne   @loop
0782 EEE2 85 04                 sta   TempZero+4
0783 EEE4 80 1B                 bra   cont3                    ;done
0784 EEE6
0785 EEE6 C9 F0 00     cont1    cmp   #$F0                     ;check for special case of -16
0786 EEE9 D0 08                 bne   cont2
0787 EEEB A5 06                 lda   TempZero+6               ;set low word to high word and zero high word
0788 EEED 85 04                 sta   TempZero+4
0789 EEEF 64 06                 stz   TempZero+6
0790 EEF1 80 0E                 bra   cont3
0791 EEF3
0792 EEF3 09 00 FF     cont2    ora   #$FF00                   ;do arithmetic right shift of 4 bytes
0793 EEF6 AA                    tax                            ;X is two's complimented shift count here
0794 EEF7 A5 04                 lda   TempZero+4
0795 EEF9              @loop     
0796 EEF9 46 06                 lsr   TempZero+6
0797 EEFB 6A                    ror   a
0798 EEFC E8                    inx   
0799 EEFD D0 FA                 bne   @loop
0800 EEFF 85 04                 sta   TempZero+4
0801 EF01              ;
0802 EF01              ;        store patch (Bytes only)
0803 EF01              ;
0804 EF01 AD 04 A7     cont3    lda   |Record+Bytes            ;check for special case of 2 bytes
0805 EF04 C9 02 00              cmp   #2
0806 EF07 D0 07                 bne   cont3a
0807 EF09 A5 04                 lda   TempZero+4               ;move word directly
0808 EF0B 87 00                 sta   [TempZero]
0809 EF0D 4C 07 E9              jmp   Reloc_Loop
0810 EF10
0811 EF10 A2 00 00     cont3a   ldx   #0                       ;move 1 byte at a time
0812 EF13 9B                    txy   
0813 EF14 E2 30                 sep   #$30
0814 EF16                       longa off
0815 EF16                       longi off
0816 EF16 B5 04        loop     lda   TempZero+4,x
0817 EF18 97 00                 sta   [TempZero],y
0818 EF1A C8                    iny   
0819 EF1B E8                    inx   
0820 EF1C EC 04 A7              cpx   |Record+Bytes
0821 EF1F D0 F5                 bne   loop
0822 EF21 C2 30        cont4    rep   #$30
0823 EF23                       longa on
0824 EF23                       longi on
0825 EF23 4C 07 E9              jmp   Reloc_Loop
0826 EF26
0827 EF26                       ENDP 
0828 EF26
